#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Non-Photorealistic TryMod01.fsh  by   WingStone
//https://www.shadertoy.com/view/MtyBDV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define EPS 0.001

//value noise
//reference: https://www.shadertoy.com/view/4sfGzS

vec2 hash( vec2 p ) // replace this by something better
{
	p = vec2( dot(p,vec2(127.1,311.7)), dot(p,vec2(269.5,183.3)) );
	return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}

float NoiseCloud(vec3 pos)
{
    pos *=2.0;
    vec3 p = floor(pos);
    vec3 f = fract(pos);
    vec2 uv = p.xy + vec2(37.0, 17.0)*p.z + f.xy;
    
    vec2 rg = texture2D(texture0, (uv+0.5)/256.0).yx;
    return mix(rg.x, rg.y, f.z)*2.0-1.0;
}

// water
float Noise( in vec3 pos )
{
    vec2 p = pos.xz;
    
    const float K1 = 0.366025404; // (sqrt(3)-1)/2;
    const float K2 = 0.211324865; // (3-sqrt(3))/6;

	vec2  i = floor( p + (p.x+p.y)*K1 );
    vec2  a = p - i + (i.x+i.y)*K2;
    float m = step(a.y,a.x); 
    vec2  o = vec2(m,1.0-m);
    vec2  b = a - o + K2;
	vec2  c = a - 1.0 + 2.0*K2;
    vec3  h = max( 0.5-vec3(dot(a,a), dot(b,b), dot(c,c) ), 0.0 );
	vec3  n = h*h*h*h*vec3( dot(a,hash(i+0.0)), dot(b,hash(i+o)), dot(c,hash(i+1.0)));
    return dot( n, vec3(70.0) );
}

float Random(vec2 uv)
{
    return texture2D(texture0, uv).y;
}

float HightFunction(vec3 pos)
{
    float hight = 0.15*Noise(pos*0.2)*(sin(pos.x)
                       + 1.1*sin(pos.z + iTime));
    hight += 0.05*(pow((sin(pos.x - 1.5*pos.z + iTime*3.0)+1.)/2.,1.5));
    return hight*0.3;
}

float CloudHightFunction_1(vec3 dir)
{
    float hight = 0.01*(sin(10.*dir.x + iTime*0.5)) + dir.y + 0.25;
    return hight;
}

float CloudHightFunction_2(vec3 dir)
{
    float hight = NoiseCloud(dir*1.5)*0.2*(sin(10.*dir.x + 1.)) + dir.y+ 0.03 +0.05*Noise(dir*5.);
    return hight ;
}

float CloudHightFunction_3(vec3 dir)
{
    float hight =  NoiseCloud(dir*6.2) + 0.4*(NoiseCloud(dir*12.))+ dir.y*8.;
    return hight ;
}

float CloudDistanceFuntion(vec3 dir, vec3 dircenter, float noise_if, float noise_of)
{
    float c = distance(normalize(dircenter), dir) + NoiseCloud(dir*noise_if)*noise_of;
    return c;
}

vec3 GetNormal(vec3 pos)
{
    vec3 dx = vec3(EPS, HightFunction(pos+vec3(EPS, 0.0, 0.0))-HightFunction(pos), 0.0);
    vec3 dz = vec3(0, HightFunction(pos+vec3(0.0, 0.0, EPS))-HightFunction(pos), EPS);
    return normalize(cross(dz, dx));
}

float RayMatching(vec3 rayOri, vec3 rayDir, float random)
{
    if(rayDir.y >= 0.0)
        return -1.0;

	float nearDist = 0.1f;
    float farDist = 100.0f;
    float stp = 0.05f;
    
    float d = nearDist;
    float lastHeight;
    float lastPosy;
    rayOri += random*stp*rayDir;  //dither
    while(d < farDist)
    {
        vec3 pos = rayOri + rayDir*d;
        float hight = HightFunction(pos);    
        if(hight > pos.y)
        {
            //intersection
            float delt = hight - pos.y;
            float lastDelt = lastPosy -lastHeight;
            return d + stp*lastDelt/(lastDelt + delt);
        }
        lastHeight = hight;
        lastPosy = pos.y;
        stp += 0.01;
        d += stp;
    }

    return -1.0;
}

vec3 GetSkyCol(vec3 dir)
{
    vec3 lightDir = normalize(vec3(-0.3, 0.3, 1.));
    float bk_factor = dot(dir, lightDir);
    vec3 lightCol = vec3(1.0,0.97,0.94);
    vec3 cloudCol1 = vec3(0.68, 0.86, 0.93);
    vec3 cloudCol2 = vec3(0.87, 0.95, 0.96);
    vec3 cloudCol3 = vec3(0.81, 0.93, 0.96);
    vec3 col = mix(vec3(0.22, 0.59, 0.81), lightCol,
                   clamp(0.0, 1.0, pow(bk_factor,64.0)) + smoothstep(0.998,1.0, bk_factor));
    
    vec3 cloud_light;
	float edgenoise = 0.014*Noise(dir*20.);
    
    float dis = CloudDistanceFuntion(dir+ vec3(0.005, 0.008, 0.), vec3(-0.6,0., 1.), 10., 0.05);
    cloud_light = mix(cloudCol1, cloudCol2, smoothstep(0.3, 0.31, dis+edgenoise));
    col = mix(cloud_light, col,
              smoothstep(0.315, 0.32,CloudDistanceFuntion(dir, vec3(-0.6,0., 1.), 10., 0.05)));
    
    dis = CloudDistanceFuntion(dir+ vec3(0.005, 0.004, 0.), vec3(0.4,-0.1, 1.), 5., 0.05);
    cloud_light = mix(cloudCol1, cloudCol2, smoothstep(0.3, 0.31, dis+edgenoise));
    col = mix(cloud_light, col,
              smoothstep(0.315, 0.32,CloudDistanceFuntion(dir, vec3(0.4,-0.1, 1.), 5., 0.05)));
    
    cloud_light = cloudCol1;
    if(CloudHightFunction_2(dir + vec3(0.02, 0.015, 0.)) + edgenoise> 0.21)
        cloud_light = cloudCol2;
    col = mix(cloud_light, col,
              smoothstep(0.2,0.205, CloudHightFunction_2(dir) +0.015*Noise(dir*14.)));
    
    cloud_light = cloudCol1;
    if(CloudHightFunction_3(dir + vec3(0.02, 0.003, 0.)) + edgenoise> 0.32)
        cloud_light = cloudCol2;
    col = mix(cloud_light, col,
              smoothstep(0.29, 0.3,CloudHightFunction_3(dir)));
    
    cloudCol3 = mix(  vec3(0.22, 0.59, 0.81),cloudCol3,smoothstep(-0.125,-0.05, dir.y));
	col = mix(cloudCol3, col,
              smoothstep(0.2, 0.21,CloudHightFunction_1(dir) +0.015*Noise(dir*15.) ));
    

    
    return col;
}

vec3 CalculateCol(vec3 pos, vec3 nor, vec3 viewDir)
{
  	vec3 specDir = normalize(reflect(viewDir, nor));
    vec3 skycol = GetSkyCol(specDir);
    return skycol;
}
        

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 uv = (fragCoord.xy * 2.0 - iResolution.xy)/iResolution.y;
    vec3 camera = vec3(0, 10.0, 0.);
    vec3 target = vec3(0.0, 9.98, 1.0);
    
    vec3 front = normalize(target - camera);
    vec3 right = cross(vec3(0.0, 1.0, 0.0), front);
    vec3 up = cross(front,right);
    vec3 rayDir = normalize(front*1.732 + uv.x*right + uv.y*up);
    
    float random = Random(uv);
    float dist = RayMatching(camera, rayDir, random);
    
    vec3 pos = camera + rayDir*dist;
    vec3 nor = GetNormal(pos);
    
    vec3 col;
    if(dist < 0.0)
    {
        col = GetSkyCol(rayDir);
    }
    else
    {
    	col = CalculateCol(pos, nor, rayDir);
        col = mix( col, vec3(0.22, 0.59, 0.81),smoothstep(80.,110., dist));
    }
    
    //col = vec3(random,random,random);
    fragColor = vec4(col, 1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length ( vec3(0.477) - gl_FragColor.rgb );
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

